# 力扣上的代码想在本地编译运行？


很多录友都问过我一个问题，就是力扣上的代码如何在本地编译运行？

其实在代码随想录刷题群里也经常出现这个场景，就是录友发一段代码上来，问大家这个代码怎么有问题？ 如果我看到了一般我的回复：都是把那几个变量或者数组打印一下看看对不对，就知道了。

然后录友就问了：如何打日志呢？

其实在力扣上打日志也挺方便的，我一般调试就是直接在力扣上打日志，偶尔需要把代码粘到本地来运行添加日志debug一下。

在力扣上直接打日志，这个就不用讲，C++的话想打啥直接cout啥就可以了。

我来说一说力扣代码如何在本地运行。

毕竟我们天天用力扣刷题，也应该知道力扣上的代码如何在本地编译运行。

其实挺简单的，大家看一遍就会了。

我拿我们刚讲过的这道题[动态规划：使用最小花费爬楼梯](https://programmercarl.com/0746.使用最小花费爬楼梯.html)来做示范。

力扣746. 使用最小花费爬楼梯，完整的可以在直接本地运行的C++代码如下：

```CPP
#include <iostream>
#include <vector>
using namespace std;

class Solution {
public:
    int minCostClimbingStairs(vector<int>& cost) {
        vector<int> dp(cost.size());
        dp[0] = cost[0];
        dp[1] = cost[1];
        for (int i = 2; i < cost.size(); i++) {
            dp[i] = min(dp[i - 1], dp[i - 2]) + cost[i];
        }
        return min(dp[cost.size() - 1], dp[cost.size() - 2]);
    }
};

int main() {
    int a[] = {1, 100, 1, 1, 1, 100, 1, 1, 100, 1};
    vector<int> cost(a, a + sizeof(a) / sizeof(int));
    Solution solution;
    cout << solution.minCostClimbingStairs(cost) << endl;
}
```

大家可以拿去跑一跑，直接粘到编译器上就行了。

我用的是linux下gcc来编译的，估计粘到其他编译器也没问题。

代码中可以看出，其实就是定义个main函数，构造个输入用例，然后定义一个solution变量，调用minCostClimbingStairs函数就可以了。

此时大家就可以随意构造测试数据，然后想怎么打日志就怎么打日志，没有找不出的bug。






-----------------------
<div align="center"><img src='https://file1.kamacoder.com/i/algo/01二维码.jpg' width=450> </img></div>
